	function [Zm1,Zm2] = bp_find_arcmin_epb(Z1,Z2,NIN,NZ,q)
	
	% Finds the arc minimum frequencies in the stopbands
	% given the attenuation pole vectors Z1 and Z2, 
	% the number of attenuation poles at infinity NIN, 
	% the number of attenuation poles at the origin NZ 
	% and the passband quotient q = wb/wa.
	% Z1 lower stopband
	% Z2 upper stopband
	
	% 	Toolbox for DIGITAL FILTERS USING MATLAB
	
	% Author: 			Per Loewenborg
    % Modified by:		 
	% Copyright:		by authors - not released for commercial use
	% Version: 			1	
	% Known bugs:		None
	% Report bugs to:	lars.wanhammar@liu.se
	
	Zm1 = [];
	Zm2 = [];
	Ztot = [Z2 Z1];
	% Upper stopband
	N = length(Z2);
	if NIN > 0 
		if N > 1 
			for k = 1:N-1
				ZA = Z2(k);
				ZB = Z2(k+1);
				ZZA = ZA*ZA;
				ZZB = ZB*ZB;
				ZZ0 = ZA*ZB;
				D0 = bp_d_func(Ztot,NIN,NZ,q,ZZ0);
				ZZ1 = ZZ0-1e-6;
				while abs(ZZ1-ZZ0) > 1e-9  % Shall be smaller than the tolerance above.
					D1 = bp_d_func(Ztot,NIN,NZ,q,ZZ1);
					ZZ2 = (ZZ0*D1-ZZ1*D0)/(D1-D0);
					if (ZZ2 < ZZA)
						ZZ2 = ZZA+0.001;      
					end 			   
					if (ZZ2 > ZZB)
						ZZ2 = ZZB-0.01;
					end 			   
					D0 = D1;
					ZZ0 = ZZ1;
					ZZ1 = ZZ2;
				end 			   
				Zm2 = [Zm2 sqrt(ZZ2)];
			end 			   
			% Last arc
			ZA = Z2(N);
			ZZA = ZA*ZA;
			ZZ0 = ZA;
			ZZ0 = (((NIN/2)*ZA+1)/(ZA+(NIN/2)))*ZZ0;
			D0 = bp_d_func(Ztot,NIN,NZ,q,ZZ0);
			ZZ1 = ZZ0-1e-6;
			while abs(ZZ1-ZZ0) > 1e-9    % Shall be smaller than the tolerance above.
				D1 = bp_d_func(Ztot,NIN,NZ,q,ZZ1);
				ZZ2 = (ZZ0*D1-ZZ1*D0)/(D1-D0);
				if (ZZ2 < ZZA)
					ZZ2 = ZZA+0.0001;      
				end
				if (ZZ2 > 1)
					ZZ2 = 0.9999;
				end
				D0 = D1;
				ZZ0 = ZZ1;
				ZZ1 = ZZ2;
			end         
			Zm2 = [Zm2 sqrt(ZZ2)];
			
		elseif N == 1
			ZA = Z2(N);
			ZZA = ZA*ZA;
			ZZ0 = ZA;
			ZZ0 = (((NIN/2)*ZA+1)/(ZA+(NIN/2)))*ZZ0;
			D0 = bp_d_func(Ztot,NIN,NZ,q,ZZ0);
			ZZ1 = ZZ0-1e-6;
			while abs(ZZ1-ZZ0) > 1e-9    % Shall be smaller than the tolerance above.
				D1 = bp_d_func(Ztot,NIN,NZ,q,ZZ1);
				ZZ2 = (ZZ0*D1-ZZ1*D0)/(D1-D0);
				if (ZZ2 < ZZA)
					ZZ2 = ZZA+0.001;      
				end
				if (ZZ2 > 1)
					ZZ2 = 0.99;
				end
				D0 = D1;
				ZZ0 = ZZ1;
				ZZ1 = ZZ2;
			end    
			Zm2 = [Zm2 sqrt(ZZ2)];
		else  
			disp('No attenuation poles in upper stop band.')
		end  
	elseif NIN == 0  
		if N > 1    
			for k = 1:N-1
				ZA = Z2(k);
				ZB = Z2(k+1);
				ZZA = ZA*ZA;
				ZZB = ZB*ZB;
				ZZ0 = ZA*ZB;
				D0 = bp_d_func(Ztot,NIN,NZ,q,ZZ0);
				ZZ1 = ZZ0-1e-6;
				while abs(ZZ1-ZZ0) > 1e-9  % Shall be smaller than the tolerance above.
					D1 = bp_d_func(Ztot,NIN,NZ,q,ZZ1);
					ZZ2 = (ZZ0*D1-ZZ1*D0)/(D1-D0);
					if (ZZ2 < ZZA)
						ZZ2 = ZZA+0.001;      
					end 			   
					if (ZZ2 > ZZB)
						ZZ2 = ZZB-0.01;
					end 			   
					D0 = D1;
					ZZ0 = ZZ1;
					ZZ1 = ZZ2;
				end 			   
				Zm2 = [Zm2 sqrt(ZZ2)];
			end 			    
			% Last arc    
			ZZ2 = 1; % 0.9999999
			Zm2 = [Zm2 ZZ2];
		elseif N == 1    
			ZZ2 = 1; % 0.9999999
			Zm2 = [Zm2 ZZ2];
		else    
			disp('No attenuation poles in upper stop band.')
		end
	else
		disp('Error-Negative number of attenuation poles at infinity.')
	end

	% lower stopband
	N = length(Z1);
	if NZ > 0
		if N > 1
			for k = 1:N-1
				ZA = Z1(k);
				ZB = Z1(k+1);
				ZZA = ZA*ZA;
				ZZB = ZB*ZB;
				ZZ0 = ZA*ZB;
				D0 = bp_d_func(Ztot,NIN,NZ,q,ZZ0);
				ZZ1 = ZZ0-1e-6;
				while abs(ZZ1-ZZ0) > 1e-9 	    % Shall be smaller than the tolerance above.
					D1 = bp_d_func(Ztot,NIN,NZ,q,ZZ1);
					ZZ2 = (ZZ0*D1-ZZ1*D0)/(D1-D0);
					if (ZZ2 < ZZA)
						ZZ2 = ZZA+0.001;      
					end 			   
					if (ZZ2 > ZZB)
						ZZ2 = ZZB-0.001;
					end 			   
					D0 = D1;
					ZZ0 = ZZ1;
					ZZ1 = ZZ2;
				end 			   
				Zm1 = [Zm1 sqrt(ZZ2)];
			end 			   
			% First arc
			ZB = Z1(1);
			ZZB = ZB*ZB;
			ZZ0 = (((NZ/2)*ZB+q)/(ZB+(NZ/2)*q))*q*ZB;
			D0 = bp_d_func(Ztot,NIN,NZ,q,ZZ0);
			ZZ1 = ZZ0-1e-6;
			while abs(ZZ1-ZZ0) > 1e-9 	    % Shall be smaller than the tolerance above.
				D1 = bp_d_func(Ztot,NIN,NZ,q,ZZ1);
				ZZ2 = (ZZ0*D1-ZZ1*D0)/(D1-D0);
				if (ZZ2 < q)
					ZZ2 = q+0.0001;      
				end
				if (ZZ2 > ZZB)
					ZZ2 = ZZB-0.0001;
				end
				D0 = D1;
				ZZ0 = ZZ1;
				ZZ1 = ZZ2;
			end         
			Zm1 = sort([Zm1 sqrt(ZZ2)]);
			
		elseif N == 1
			ZB = Z1(1);
			ZZB = ZB*ZB;
			ZZ0 = (((NZ/2)*ZB+q)/(ZB+(NZ/2)*q))*q*ZB;
			D0 = bp_d_func(Ztot,NIN,NZ,q,ZZ0);
			ZZ1 = ZZ0-1e-6;
			while abs(ZZ1-ZZ0) > 1e-9 	    % Shall be smaller than the tolerance above.
				D1 = bp_d_func(Ztot,NIN,NZ,q,ZZ1);
				ZZ2 = (ZZ0*D1-ZZ1*D0)/(D1-D0);
				if (ZZ2 < q)
					ZZ2 = q+0.0001;      
				end
				if (ZZ2 > ZZB)
					ZZ2 = ZZB-0.0001;
				end
				D0 = D1;
				ZZ0 = ZZ1;
				ZZ1 = ZZ2;
			end         
			Zm1 = [Zm1 sqrt(ZZ2)];
		else
			disp('No attenuation poles in lower stop band.')
		end
	
	elseif NZ == 0
		if N > 1
			for k = 1:N-1
				ZA = Z1(k);
				ZB = Z1(k+1);
				ZZA = ZA*ZA;
				ZZB = ZB*ZB;
				ZZ0 = ZA*ZB;
				D0 = bp_d_func(Ztot,NIN,NZ,q,ZZ0);
				ZZ1 = ZZ0-1e-6;
				while abs(ZZ1-ZZ0) > 1e-9 	    % Shall be smaller than the tolerance above.
					D1 = bp_d_func(Ztot,NIN,NZ,q,ZZ1);
					ZZ2 = (ZZ0*D1-ZZ1*D0)/(D1-D0);
					if (ZZ2 < ZZA)
						ZZ2 = ZZA+0.001;      
					end 			   
					if (ZZ2 > ZZB)
						ZZ2 = ZZB-0.01;
					end 			   
					D0 = D1;
					ZZ0 = ZZ1;
					ZZ1 = ZZ2;
				end 			   
				Zm1 = [Zm1 sqrt(ZZ2)];
			end 			   
			% First arc    
			Zm1 = sort([Zm1 q]);
		elseif N == 1
			Zm1 = sort([Zm1 q]);
		else
			disp('No attenuation poles in lower stop band.')
		end
	else
		disp('Error-Negative number of attenuation poles at the origin.');
	end
